<?php
require_once '../config.php';

echo "<h1>Add Missing Columns to Purchase Orders Table</h1>";

try {
    // Add closed_by column
    $stmt = $pdo->prepare("ALTER TABLE purchase_orders ADD COLUMN closed_by INT NULL");
    $stmt->execute();
    echo "<p style='color: green;'>✓ Added closed_by column</p>";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') === false) {
        echo "<p style='color: red;'>Error adding closed_by: " . $e->getMessage() . "</p>";
    } else {
        echo "<p style='color: blue;'>⚠ closed_by column already exists</p>";
    }
}

try {
    // Add closed_at column
    $stmt = $pdo->prepare("ALTER TABLE purchase_orders ADD COLUMN closed_at TIMESTAMP NULL");
    $stmt->execute();
    echo "<p style='color: green;'>✓ Added closed_at column</p>";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') === false) {
        echo "<p style='color: red;'>Error adding closed_at: " . $e->getMessage() . "</p>";
    } else {
        echo "<p style='color: blue;'>⚠ closed_at column already exists</p>";
    }
}

try {
    // Add foreign key for closed_by
    $stmt = $pdo->prepare("ALTER TABLE purchase_orders ADD FOREIGN KEY (closed_by) REFERENCES users(id)");
    $stmt->execute();
    echo "<p style='color: green;'>✓ Added foreign key for closed_by</p>";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate key name') === false &&
        strpos($e->getMessage(), 'already exists') === false) {
        echo "<p style='color: red;'>Error adding foreign key: " . $e->getMessage() . "</p>";
    } else {
        echo "<p style='color: blue;'>⚠ Foreign key already exists</p>";
    }
}

// Verify columns exist
echo "<h2>Verification:</h2>";
$columns_to_check = ['closed_by', 'closed_at'];

foreach ($columns_to_check as $column) {
    try {
        $stmt = $pdo->query("SHOW COLUMNS FROM purchase_orders LIKE '$column'");
        if ($stmt->fetch()) {
            echo "<p style='color: green;'>✓ Column '$column' exists in purchase_orders</p>";
        } else {
            echo "<p style='color: red;'>✗ Column '$column' missing in purchase_orders</p>";
        }
    } catch (PDOException $e) {
        echo "<p style='color: red;'>Error checking column '$column': " . $e->getMessage() . "</p>";
    }
}

echo "<h2 style='color: green;'>Column addition completed!</h2>";
?>
